<?php
/* Smarty version 4.5.5, created on 2025-02-25 09:28:44
  from '/home/life/public_html/ideal-color.lifestyle.uz/admin/templates/views/documents/csrf.tpl' */

/* @var Smarty_Internal_Template $_smarty_tpl */
if ($_smarty_tpl->_decodeProperties($_smarty_tpl, array (
  'version' => '4.5.5',
  'unifunc' => 'content_67bd8d4c950b16_82824135',
  'has_nocache_code' => false,
  'file_dependency' => 
  array (
    'c528905d3be5a110d706f02dca34ad2b55da8576' => 
    array (
      0 => '/home/life/public_html/ideal-color.lifestyle.uz/admin/templates/views/documents/csrf.tpl',
      1 => 1727543383,
      2 => 'file',
    ),
  ),
  'includes' => 
  array (
    'file:components/page-header.tpl' => 1,
  ),
),false)) {
function content_67bd8d4c950b16_82824135 (Smarty_Internal_Template $_smarty_tpl) {
?><!-- Inner content -->
<div class="content-inner" data-bs-spy="scroll" data-bs-target="#page_nav">

	<!-- Page header -->
    <?php $_smarty_tpl->smarty->ext->_capture->open($_smarty_tpl, "buttons", null, null);
$_smarty_tpl->smarty->ext->_capture->close($_smarty_tpl);?>

    <?php $_smarty_tpl->smarty->ext->_capture->open($_smarty_tpl, "breadcrumb", null, null);?>
		<span class="breadcrumb-item active"><?php echo htmlspecialchars((string)$_smarty_tpl->tpl_vars['title']->value, ENT_QUOTES, 'UTF-8', true);?>
</span>
    <?php $_smarty_tpl->smarty->ext->_capture->close($_smarty_tpl);?>

    <?php $_smarty_tpl->smarty->ext->_capture->open($_smarty_tpl, "showBy", null, null);
$_smarty_tpl->smarty->ext->_capture->close($_smarty_tpl);?>

    <?php $_smarty_tpl->_subTemplateRender("file:components/page-header.tpl", $_smarty_tpl->cache_id, $_smarty_tpl->compile_id, 0, $_smarty_tpl->cache_lifetime, array('buttons'=>$_smarty_tpl->smarty->ext->_capture->getBuffer($_smarty_tpl, 'buttons'),'breadcrumb'=>$_smarty_tpl->smarty->ext->_capture->getBuffer($_smarty_tpl, 'breadcrumb'),'showBy'=>$_smarty_tpl->smarty->ext->_capture->getBuffer($_smarty_tpl, 'showBy')), 0, false);
?>
	<!-- /page header -->
	<!-- Content area -->
	<div class="content">

		<!-- Inner container -->
		<div class="d-flex align-items-stretch align-items-lg-start flex-column flex-lg-row">

			<!-- Left content -->
			<div class="flex-1 order-2 order-lg-1">

				<!-- Scrollspy -->
				<div class="card">
					<div class="card-header"><h5 class="mb-0">SecurityCsrfToken</h5></div>

					<div class="card-body">
						<div class="mb-4">
							<h6 class="fw-semibold" id="introduction">Введение</h6>
							<p><span class="fw-semibold">SecurityCsrfToken</span> — это простая, автономная библиотека защиты CSRF, написанная на PHP. Ее можно использовать
								для защиты форм от атак <a href="http://en.wikipedia.org/wiki/Cross-site_request_forgery" target="_blank" rel="nofollow">[Cross Site Request Forgery]</a> .</p>

						</div>
						<div class="mb-4">
														<div class="mb-3">
								<h6 class="fw-semibold" id="requirements">Требования</h6>
								<h6 class="fw-semibold">PHP 7.3+</h6>

								<p>Запустите <code>composer install</code>, а затем используйте как обычно:</p>
								<pre class="language-php">
									<code>
require 'vendor/autoload.php';

$sessionProvider = new Mnv\Core\Security\Csrf\SecurityCsrfSessionProvider();
$securityCsrfToken = new Mnv\Core\Security\Csrf\SecurityCsrfToken($sessionProvider);
									</code>
								</pre>
							</div>
							
														<div class="mb-3">
								<h6 class="fw-semibold" id="usage">Использование</h6>
								<p>Чтобы использовать <code>SecurityCsrfToken</code>, сначала вам нужно сгенерировать токен:</p>
								<pre class="language-php mb-3">
									<code>
// хранение токена в сессии
$sessionProvider = new Mnv\Core\Security\Csrf\SecurityCsrfSessionProvider();
$securityCsrfToken = new Mnv\Core\Security\Csrf\SecurityCsrfToken($sessionProvider);

// или хранение токена в куках
$cookieProvider = new Mnv\Core\Security\Csrf\SecurityCsrfCookieProvider();
$securityCsrfToken = new Mnv\Core\Security\Csrf\SecurityCsrfToken($cookieProvider);

$securityCsrfToken = new Mnv\Core\Security\Csrf\SecurityCsrfToken($sessionProvider);

$token = $securityCsrfToken->generate('token');
									</code>
								</pre>
								<p>Затем вы включаете этот токен во все создаваемые вами формы используя <code>smarty_function_security_csrf_token</code>, где использыуется код написаный выше:</p>
								<pre class="language-php mb-3">
									<code>
&lt;form>

    // вернет готовый input с токеном
    {security_csrf_token input=true}

	// вызываем функцию и в assign указываем название переменной
    {security_csrf_token assign=token input=false}
	// выводим значение переменой {$token}
	&lt;input type="hidden" name="token" value="{$token}" class="form-control d-none">

    // вернет токен
    &lt;input type="hidden" name="token" value="{security_csrf_token input=false}" class="form-control d-none">

&lt;/form>
									</code>
								</pre>
								<p>Затем, прежде чем приступать к обработке данных из форм, проверьте действительность токена:</p>
								<pre class="language-php mb-3">
									<code>
use Mnv\Core\Security\Csrf\Exceptions\InvalidCsrfTokenException;

try {
	$formToken = request()->get('token', '');
    $securityCsrfToken->check('token', $formToken);
} catch(InvalidCsrfTokenException $e) {
    echo $e->getMessage();
}
									</code>
								</pre>
							</div>
							
														<div class="mb-3">
								<h6 class="fw-semibold" id="token_expiration">Истечение срока действия токена</h6>
								<p>Вы можете установить ограничение по времени для токенов, передав временной интервал (<span class="fw-semibold">в секундах</span>) в метод проверки. <br>
									Токены старше временного интервала не будут действительны.</p>
								<pre class="language-php">
									<code>
// Example 1 hour expiration
$securityCsrfToken->check('token', $_POST['token'], 60 * 60);
									</code>
								</pre>
							</div>
							
														<div class="mb-3">
								<h6 class="fw-semibold" id="reusable_tokens">Многоразовые токены</h6>
								<p>Токены можно сделать многоразовыми, а не одноразовыми (полезно для запросов с большим объемом AJAX).</p>
								<pre class="language-php">
									<code>
// Make token reusable
$securityCsrfToken->check('token', $_POST['token'], null, true);
									</code>
								</pre>
							</div>
							
														<div class="mb-3">
								<h6 class="fw-semibold" id="custom_sessionProvider">Кастомный SessionProvider</h6>
								<p>Приложение может использовать стороннюю библиотеку для управления сеансами, или вы можете хранить токены где-то еще, а не в $_SESSION (как это делает <code>SecurityCsrfSessionProvider</code>).<br>
									В этом случае вы можете создать пользовательский <code>SessionProvider</code> и использовать его при создании экземпляра <code>SecurityCsrfToken</code>.</p>
								<pre class="language-php mb-2">
									<code>
use Mnv\Core\Security\Csrf\Interfaces\SessionProvider;

class CustomSessionProvider implements SessionProvider
{
    /**
     * Get a session value.
     *
     * @param string $key
     * @return mixed
     */
    public function get(string $key)
    {
        // Return your stored data
    }

    /**
     * Set a session value.
     *
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function set(string $key, $value)
    {
        // Store your data
    }

}
									</code>
								</pre>

							</div>
							

						</div>


					</div>
				</div>
			</div>

			<div class="sticky-lg-top order-1 order-lg-2 wmin-lg-300 ms-lg-3 mb-3" id="page_nav">
				<h6 class="fw-semibold mt-lg-3 mb-3">SecurityCsrfToken</h6>

				<ul class="nav nav-scrollspy flex-column">
					<li class="nav-item"><a class="nav-link" href="#requirements">Требования</a></li>
					<li class="nav-item"><a class="nav-link" href="#usage">Использование</a></li>
					<li class="nav-item"><a class="nav-link" href="#token_expiration">Истечение срока действия токена</a></li>
					<li class="nav-item"><a class="nav-link" href="#reusable_tokens">Многоразовые токены</a></li>
					<li class="nav-item"><a class="nav-link" href="#custom_sessionProvider">Кастомный SessionProvider</a></li>
				</ul>

			</div>

		</div>

	</div>
</div><?php }
}
